# ibidi Tracks Plot

A free tool from MetaVi Labs for generating publication-quality chemotaxis trajectory plots from ibidi-style track data.

## Overview

This Python script transforms cell tracking data into standardized ibidi chemotaxis plots, properly accounting for chemoattractant reservoir location and coordinate system transformations.

## Features

- **Automatic coordinate transformation** based on reservoir location (Top/Bottom/Right/Left)
- **ibidi-standard visualization** with trajectory accumulation and Euclidean distance
- **Publication-ready output** at 200 DPI
- **Flexible origin normalization** (per-track or center-of-mass)
- **Center of mass (M_end) calculation** and visualization

## Installation

Requires Python 3.7+ with:
```bash
pip install numpy pandas matplotlib
```

## Usage

```bash
python ibidi_tracks_plot.py input_tracks.txt --reservoir Bottom --out plot.png
```

### Arguments

- `input` - Path to ibidi Tracks TSV file
- `--reservoir` - Chemoattractant location: `Bottom`, `Top`, `Right`, or `Left` (required)
- `--origin` - Normalization mode: `per_track` (default) or `com_start`
- `--out` - Output filename (default: `ibidi_plot.png`)
- `--title` - Optional plot title
- `--no-show` - Suppress interactive display

### Example

```bash
python ibidi_tracks_plot.py my_tracks.txt --reservoir Bottom --title "Chemotaxis Assay" --out chemotaxis_plot.png
```

## Input Format

Tab-separated file with columns:
- `Track n` - Track ID
- `Slice n` - Frame number
- `x` - X coordinate (pixels)
- `y` - Y coordinate (pixels)

## Output

PNG image showing:
- **Red trajectories** - Cell paths (accumulated distance)
- **Blue dashed line** - Euclidean distance from origin to M_end
- **Gray dots** - Track endpoints
- **Blue cross** - Center of mass (M_end)
- **Black X** - Origin (M_start)

## Coordinate Systems

**Image coordinates** (input):
- Origin: top-left
- +X: right
- +Y: down

**ibidi coordinates** (output):
- +Y: toward chemoattractant (parallel to gradient)
- +X: perpendicular to gradient (90° clockwise)

## License

Copyright 2025 MetaVi Labs Inc.

Licensed under the Apache License, Version 2.0. See LICENSE file for details.

## Contact

MetaVi Labs Inc.  
https://www.metavilabs.com

## Citation

If you use this tool in your research, please cite:

```
MetaVi Labs Inc. (2025). ibidi Tracks Plot Tool.
https://www.metavilabs.com
```
